<?php

namespace App\Http\Controllers;

use App\AskmDimPelanggaran;
use App\AskmDimPenilaian;
use App\AskmPoinKebaikan;
use App\DimxDim;
use App\Keasramaan;
use Illuminate\Http\Request;

class KeasramaanController extends ResponseController
{
    //
    public function getDataAsrama()
    {
        $userLogin = \JWTAuth::parseToken()->authenticate();
        $id = $userLogin->user_id;
        $asrama = DimxDim::leftJoin('askm_dim_kamar',function ($join){
            $join->on('dimx_dim.dim_id','=','askm_dim_kamar.dim_id');
        })->leftJoin('askm_kamar',function ($join){
            $join->on('askm_dim_kamar.kamar_id','=','askm_kamar.kamar_id');
        })->leftJoin('askm_asrama',function ($join){
            $join->on('askm_kamar.asrama_id','=','askm_asrama.asrama_id');
        })->leftJoin('askm_keasramaan',function($join){ 
            $join->on('askm_asrama.asrama_id','=','askm_keasramaan.asrama_id');
        })->leftJoin('hrdx_pegawai',function ($join){
            $join->on('askm_keasramaan.pegawai_id','=','hrdx_pegawai.pegawai_id');
        })->where('dimx_dim.dim_id','=',$id)->first([
            "askm_asrama.name as nama_asrama",
            "askm_asrama.lokasi as lokasi_asrama",
            "askm_kamar.nomor_kamar as kamar",
            "askm_kamar.kamar_id as kamar_id",
            "askm_asrama.asrama_id as asrama_id",
        ]);
        $id_kamar =  $asrama->kamar_id;
        $id_asrama = $asrama->asrama_id;
        $pembinaAsrama = Keasramaan::leftJoin('hrdx_pegawai',function ($join){
            $join->on('askm_keasramaan.pegawai_id','=','hrdx_pegawai.pegawai_id');
        })->where('askm_keasramaan.asrama_id','=',$id_asrama)->get([
            'hrdx_pegawai.nama',
        ]);

        $teman_sekamar = DimxDim::join("inst_prodi","dimx_dim.ref_kbk_id","=","inst_prodi.ref_kbk_id")
            ->join("askm_dim_kamar","dimx_dim.dim_id","=","askm_dim_kamar.dim_id")
            ->join("askm_kamar","askm_dim_kamar.kamar_id","=","askm_kamar.kamar_id")
            ->where("dimx_dim.dim_id","!=",$id)
            ->where("askm_kamar.kamar_id","=","$id_kamar")
            ->get(["dimx_dim.nama as nama",
                "dimx_dim.thn_masuk as tahun_masuk",
                "inst_prodi.nama_kopertis_ind as prodi"]);
        $data = [
            "teman_sekamar"=>$teman_sekamar,
            "pembinaAsrama"=>$pembinaAsrama,
            "asrama"=>$asrama
        ];
        return $this->successResponse(200,$data);
    }
    public function getNilaiKeasramaan($idUser){
        $penilaian = AskmDimPenilaian::where('dim_id','=',$idUser)
            ->where('deleted','=',0)
            ->get([
                'penilaian_id as id',
                'ta as tahunAjaran',
                'sem_ta as semester',
                'akumulasi_skor as akumulasiSkor'
            ]);
        return $this->successResponse(200,$penilaian);
    }

    public function getDetailNilaiKeasramaan($idPenilaian){
        $pelanggaran = AskmDimPelanggaran::join('askm_poin_pelanggaran','askm_poin_pelanggaran.poin_id','=','askm_dim_pelanggaran.poin_id')
            ->join('askm_pembinaan','askm_pembinaan.pembinaan_id','=','askm_dim_pelanggaran.pembinaan_id')
            ->where('askm_dim_pelanggaran.penilaian_id','=',$idPenilaian)
            ->get([
                'askm_poin_pelanggaran.name as pelanggaran',
                'askm_dim_pelanggaran.tanggal as tanggal',
                'askm_poin_pelanggaran.poin as poin',
                'askm_pembinaan.name as tindakan'
            ]);
        $kebaikan = AskmPoinKebaikan::leftJoin('askm_dim_pelanggaran',function($join){
                $join->on('askm_poin_kebaikan.pelanggaran_id','=','askm_dim_pelanggaran.pelanggaran_id');
            })->where('askm_poin_kebaikan.penilaian_id','=',$idPenilaian)
            ->get([
                'askm_poin_kebaikan.name as perbuatanBaik',
                'askm_poin_kebaikan.desc as keterangan',
                'askm_dim_pelanggaran.desc_pelanggaran as pemutihan',
                'askm_dim_pelanggaran.tanggal as tanggalPelanggaran',
                'askm_poin_kebaikan.created_at as TanggalPemutihan'
            ]);
        $data = [
            'pelanggaran'=>$pelanggaran,
            'kebaikan'=>$kebaikan
        ];
        return $this->successResponse(200,$data);
    }
}
